# Experiments

## Install Dependencies
To run the experiments, you need to install the required dependencies using `poetry`. If `poetry` is not already installed, follow the instructions provided [here](https://python-poetry.org/docs/#installation). Once `poetry` is installed, run the following command in this directory to set up the required dependencies:

```shell
poetry install
```

## Running Experiments
We provide [`runner.py`](src/dada/runner.py), which allows you to run the experiments and generate plots similar to those presented in our paper. Use the commands below based on the model you want to test.

For details on the meaning of each flag, run:
```shell
poetry run experiment -h
```

### Log-Sum-Exp Model
Run the following command to test the Log-Sum-Exp (Softmax) model:
```shell
poetry run experiment LSE -d 2000 -n 1000 --mu-list 0.1 0.01 0.005 --plot --plot-dir ./plots --steps 100001 --seed 100
```

## Polynomial Feasibility Problem
Run the following command to test the Polynomial Feasibility Problem:
```shell
poetry run experiment PF -d 1000 -n 10000 -r 1000 --q-list 1 1.5 2 --plot --plot-dir ./plots --steps 5001 --seed 100
```

## Worst-instance Problem
Run the following command to test the Worst-instance model:
```shell
poetry run experiment WI -d 10000 --q-list 2 4 6 --plot --plot-dir ./plots --steps 100001 --seed 100
```
